module f

// LAZY DYNAMICS EXAMPLE - This application just puts a count_leafs-function into a dynamic

import StdDynamic
import StdDynamicFileIO
import StdEnv

import path					// do NOT forget to change absolute path

:: Tree c = Node c (Tree c) (Tree c) | Leaf

Start world
	#! (ok,world) 
		= writeDynamic (p +++ "\\function") dt world
	| not ok
		= abort "could not write dynamic"
	= (dt,world)
where  
	dt = dynamic count_leafs 
	
	 
count_leafs :: (Tree Int) -> Real
count_leafs tree 
	= toReal (count tree 1)
where

	count :: (Tree Int) Int -> Int
	count Leaf n_leafs
		= inc n_leafs
	count (Node _ left right) n_leafs
		= count left (count right n_leafs)
	count q _
		= abort "count does not match";
